<?php
header('Content-Type: application/json');
require 'connection.php';

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode([
        'status' => 'error',
        'message' => 'Only GET method allowed'
    ]);
    exit;
}

$user_lat = isset($_GET['lat']) ? floatval($_GET['lat']) : null;
$user_lng = isset($_GET['lng']) ? floatval($_GET['lng']) : null;

if ($user_lat === null || $user_lng === null) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'lat and lng are required'
    ]);
    exit;
}

$stmt = $conn->prepare("
    SELECT
        u.id as client_id,
        u.institute_code,
        u.uni_level,
        u.name,
        u.city,
        u.email,
        u.contact,
        u.latitude,
        u.longitude,
        u.radius,
        u.digipin,
        (
            6371000 * ACOS(
                COS(RADIANS(?)) * COS(RADIANS(u.latitude)) *
                COS(RADIANS(u.longitude) - RADIANS(?)) +
                SIN(RADIANS(?)) * SIN(RADIANS(u.latitude))
            )
        ) AS distance
    FROM uni_clients u
    WHERE u.status = 1
    HAVING distance <= u.radius
    ORDER BY distance ASC
");

$stmt->bind_param("ddd", $user_lat, $user_lng, $user_lat);
$stmt->execute();
$result = $stmt->get_result();

$institutes = [];

while ($row = $result->fetch_assoc()) {
    $institutes[] = $row;
}

$stmt->close();
$conn->close();

echo json_encode([
    'status' => 'success',
    'count' => count($institutes),
    'institutes' => $institutes
]);
