<?php
header('Content-Type: application/json');
require 'connection.php';

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode([
        'status' => 'error',
        'message' => 'Only GET method allowed'
    ]);
    exit;
}

if (!isset($_GET['client_id']) || trim($_GET['client_id']) === '') {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'client_id is required'
    ]);
    exit;
}

$client_id = (int) $_GET['client_id'];

$sql = "
SELECT DISTINCT
    c.id AS course_id,
    c.name AS course_name,

    y.id AS year_id,
    y.name AS year_name,
    y.numeric_value AS year_number,

    d.id AS division_id,
    d.name AS division_name

FROM uni_institute_allocations a
JOIN uni_courses c ON c.id = a.course_id
LEFT JOIN uni_years y ON y.id = a.year_id
LEFT JOIN uni_divisions d ON d.id = a.division_id

WHERE a.client_id = $client_id
  AND a.deleted_at IS NULL

ORDER BY
    c.name,
    y.numeric_value,
    d.name
";

$result = $conn->query($sql);

if (!$result) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Database query failed'
    ]);
    exit;
}

$data = [];

while ($row = $result->fetch_assoc()) {

    $courseId = $row['course_id'];
    $yearId   = $row['year_id'];

    if (!isset($data[$courseId])) {
        $data[$courseId] = [
            'course_id'   => $courseId,
            'course_name' => $row['course_name'],
            'years'       => []
        ];
    }

    if ($yearId) {
        if (!isset($data[$courseId]['years'][$yearId])) {
            $data[$courseId]['years'][$yearId] = [
                'year_id'     => $yearId,
                'year_name'   => $row['year_name'],
                'year_number' => $row['year_number'],
                'divisions'   => []
            ];
        }

        if ($row['division_id']) {
            $data[$courseId]['years'][$yearId]['divisions'][] = [
                'division_id'   => $row['division_id'],
                'division_name' => $row['division_name']
            ];
        }
    }
}

$conn->close();

$finalData = [];

foreach ($data as $course) {
    $course['years'] = array_values($course['years']);
    $finalData[] = $course;
}

echo json_encode([
    'status' => 'success',
    'data'   => $finalData
]);
